#include "config.h"

#include <unistd.h>				/* getopt */
#include <stdio.h>				/* printf */
#include <stdlib.h>				/* malloc maybe ? */
#include <string.h>

/* debugging ? */
//#define DEBUG

/* default values */

#define DEF_ICN_X 0
#define DEF_ICN_Y 0
#define DEF_ICN_W 50
#define DEF_ICN_H 50

#define DEF_MSG_X 50
#define DEF_MSG_Y 0
#define DEF_MSG_W 950
#define DEF_MSG_H 50

#define DEF_FONT "-*-lucida-bold-r-normal-*-24-*-*-*-*-*-*-*"

#define DEF_COLOR "white"
#define DEF_DURATION 4.0
#define DEF_LINE_NUMBER 0

/* internal prototypes */

void fill_blanks_config (cfg_t* cfg);
int copy_string (char** dest, char* src, char* dest_descr);
void init_config (cfg_t* cfg);
void print_config_string (char *text, char *string);


void
init_config (cfg_t* cfg)
{
  /* Clear configuration type */
  
  cfg->font_name = NULL;
  cfg->icon_file = NULL;
  cfg->color_name = NULL;
  cfg->duration = 0.0;
  cfg->line_number = 0;
}

int 
parse_config (int argc, char *argv[], cfg_t* cfg)
{
  char done = 0;				/* set to 1 when done parsing */
  char have_args = 0;			/* set to 1 when an argument has been given */
#ifdef DEBUG
  printf ("DEBUG: parse_config start\n");
#endif

  init_config (cfg);

#ifdef DEBUG
  printf ("DEBUG: filling in blanks\n");
#endif

  fill_blanks_config (cfg);
#ifdef DEBUG
  print_config (*cfg);
#endif
  
  while (! done)
  {
    char option;

    option = getopt (argc, argv, "ficdl");
    if (option == -1)
    {
      /* no arguments left */
      done = 1;
    }
    else
    {
      have_args = 1;
	    switch (option)
	    {
	      case -1:
	        done = 1;
	        break;
	      case 'f':
	        copy_string (&cfg->font_name, argv[optind], "font name\t");
	        break;
	      case 'i':
	        copy_string (&cfg->icon_file, argv[optind], "icon file name");
	        break;
	      case 'c':
	        copy_string (&cfg->color_name, argv[optind], "color name");
	        break;
	      case 'd':
	        sscanf (argv[optind], "%f", &cfg->duration);
	        break;
	      case 'l':
	        sscanf (argv[optind], "%d", &cfg->line_number);
	        break;
	    }
	    ++optind; /* skip config parameter */
	}
  } 
#ifdef DEBUG
  printf ("DEBUG: done parsing\n");
  print_config (*cfg);
  printf ("DEBUG: parse_config end\n");
#endif
  return 1 /*have_args*/;
}

void 
print_config_string (char *text, char *string)
{
  if (string != NULL)
  {
    printf ("%s\t%s\n", text, string);
  }
}

void print_config (cfg_t cfg)
{
  print_config_string ("Font name", cfg.font_name);
  print_config_string ("Icon file name", cfg.icon_file);
  print_config_string ("Color name", cfg.color_name);
  printf ("Duration\t%f\n", cfg.duration);
  printf ("Line number\t%d\n", cfg.line_number);
}

int 
copy_string (char** dest, char* src, char* dest_descr)
{
  if (*dest != NULL) free (*dest);
  *dest = (unsigned char *) malloc (strlen (src) + 1);
  if (*dest == NULL)
  {
    fprintf (stderr, "Could not alloc memory for %s !\n", dest_descr);
    return 1;
  }
  strcpy (*dest, src);
  /* null-terminate */
  (*dest)[strlen(src)] = '\0';
  return 0;
}

void 
fill_blanks_config (cfg_t* cfg)
{
  if (cfg->font_name == NULL)
    copy_string (&cfg->font_name, DEF_FONT, "font name");
  if (cfg->color_name == NULL)
    copy_string (&cfg->color_name, DEF_COLOR, "color name");
  cfg->duration = DEF_DURATION;
  cfg->line_number = DEF_LINE_NUMBER;
}
