/* message.c
 * 
 * version 0.2.1
 *
 * last changed : 10/05/2001
 *
 * currently displays the text you give as the first argument on the
 * cmdline
 * current addition : add shadowy black effect, have white text color
 */

#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

Window CreateMessageWindow (Display* dpy, int screen_num)
{
    int vmask;
    XSetWindowAttributes attribs;
    Window msg_w;

    /* message window */
    vmask = /*CWBackPixel|*/CWSaveUnder|CWOverrideRedirect|CWColormap
        |CWBorderPixel;
    attribs.save_under = True;
    attribs.override_redirect = True;
    attribs.colormap = DefaultColormap (dpy, screen_num);
    attribs.background_pixel = 1000;
/*    attribs.background_pixel = scr->icon_back_texture->normal.pixel;  */
    attribs.border_pixel = 0; /* do not care */


    msg_w =
      XCreateWindow(dpy, DefaultRootWindow (dpy), 0, 0, 1000, 40, 0,
CopyFromParent,
                    CopyFromParent, CopyFromParent, vmask, &attribs);

//    msg_w = DefaultRootWindow (dpy);
/*
  msg_w = XCreateSimpleWindow(dpy, RootWindow(dpy, screen_num),
                            0, 0, 10, 10, 0,
                            BlackPixel(dpy, screen_num),
                            WhitePixel(dpy, screen_num));
*/
    XMapWindow (dpy, msg_w);
    return msg_w;
}

GC
create_gc(Display* display, Window win, int reverse_video)
{
  GC gc;                                /* handle of newly created GC.  */
  unsigned long valuemask = 0;          /* which values in 'values'  to */
                                        /* check when creating the GC.  */
                                       /* check when creating the GC.  */
  XGCValues values;                     /* initial values for the GC.   */
  unsigned int line_width = 2;          /* line width for the GC.       */
  int line_style = LineSolid;           /* style for lines drawing and  */
  int cap_style = CapButt;              /* style of the line's edje and */
  int join_style = JoinBevel;           /*  joined lines.               */
  int screen_num = DefaultScreen(display);

  gc = XCreateGC(display, win, valuemask, &values);
  if (gc < 0) {
        fprintf(stderr, "XCreateGC: \n");
  }
  XSetSubwindowMode ( display, gc, IncludeInferiors );
  /* allocate foreground and background colors for this GC. */
  if (reverse_video) {
    XSetForeground(display, gc, WhitePixel(display, screen_num));
    XSetBackground(display, gc, BlackPixel(display, screen_num));
  }
  else {
    XSetForeground(display, gc, BlackPixel(display, screen_num));
    XSetBackground(display, gc, WhitePixel(display, screen_num));
  }
  
  /* define the style of lines that will be drawn using this GC. */
  XSetLineAttributes(display, gc,
                     line_width, line_style, cap_style, join_style);
  
  /* define the fill style for the GC. to be 'solid filling'. */
  XSetFillStyle(display, gc, FillSolid);

  return gc;
}

int 
WriteText (Display* display, Window window, XFontStruct* font_info, 
           char *text, GC gc_fg, GC gc_bo)
{
  /* display the text using a shadowy effect */

  {
    /* variables used for drawing the text strings. */
    int x, y;
    int x_off, y_off;

    //int string_width;
    int font_height;
  
    /* find the height of the characters drawn using this font.        */
    font_height = font_info->ascent + font_info->descent;

    x = 0;   
    y = font_height;    

    /* draw black border part */
    for (x_off = 0; x_off <= 3; ++x_off)
    {
      for (y_off = 0; y_off <=3; ++y_off)
      {
        XDrawString (display, window, gc_bo, x + x_off, y + y_off,
                     text,strlen(text));
      }
    }

    /* draw white top part */
    for (x_off = 1; x_off <= 2; ++x_off)
    {
      for (y_off = 1; y_off <= 2; ++y_off)
      {
        XDrawString (display, window, gc_fg, x + x_off, y + y_off,
                     text,strlen(text));
      }
    }
    /* flush all pending requests to the X server. */
    XFlush(display);      
    return 0;
  }


}
int main (int argc, char *argv[])
{
  Display* display;             /* pointer to X Display structure.           */
  Window msg_w;

  char *display_name = getenv("DISPLAY");  /* address of the X display.      */

  int screen_num;               /* number of screen to place the window on.  */
  unsigned int display_width,
               display_height;  /* height and width of the X display.        */

  GC gc, gc_bo;                        /* GC (graphics context) used for
drawing */
                                /*  in our window.                           */
  XFontStruct* font_info;       /* Font structure, used for drawing text.    */
  char* font_name = "-*-helvetica-medium-r-normal-*-24-*-*-*-*-*-*-*"; /*
font to use for drawing text.   */

  /* open connection with the X server. */
  display = XOpenDisplay(display_name);
  if (display == NULL) {
    fprintf(stderr, "%s: cannot connect to X server '%s'\n",
            argv[0], display_name);
    exit(1);
  }
  
  /* get the geometry of the default screen for our display. */
  screen_num = DefaultScreen(display);
  display_width = DisplayWidth(display, screen_num);
  display_height = DisplayHeight(display, screen_num);

  msg_w = CreateMessageWindow (display, screen_num);

  /* allocate a new GC (graphics context) for drawing in the window. */

  gc = create_gc(display, msg_w, 1);
  gc_bo = create_gc(display, msg_w, 0);
  XSync(display, False);

  /* try to load the given font. */
  font_info = XLoadQueryFont(display, font_name);
  if (!font_info) {
      fprintf(stderr, "XLoadQueryFont: failed loading font '%s'\n",font_name);
      exit(-1);
  }

  /* assign the given font to our GC. */
  XSetFont(display, gc, font_info->fid);
  XSetFont(display, gc_bo, font_info->fid);

  WriteText (display, msg_w, font_info, argv[1], gc, gc_bo);

  sleep(4);

  /* close the connection to the X server. */
  XCloseDisplay(display);

  return 1;
}
